///////////////////////////////////////////////////////////////////////////////
//
//  Implementation of broadcast server
//

#define NR_IMPLEMENTATION

#include <windows.h>
#include <commctrl.h>

#include "Ninereeds Broadcast Lib.h"

#include "resource.h"


///////////////////////////////////////////////////////////////////////////////

struct c_Listener_Def
{
	int                      f_Channel;
	c_Broadcast_Listener_CB *f_Callback;
};

///////////////////////////////////////////////////////////////////////////////

c_Listener_Def g_Listeners [NR_MAX_LISTENERS];

///////////////////////////////////////////////////////////////////////////////

namespace n_NBL
{
  HINSTANCE dllInstance;

  c_Broadcast_Listener_CB *g_Self;
  bool                    *g_Enable;
  int                     *g_Channel;
  int                      g_Num_Controls;
  c_Control_Config        *g_Controls;
};

BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  fdwreason, 
                       LPVOID lpReserved )
{
	int i;

  switch(fdwreason)
	{
    case DLL_PROCESS_ATTACH:
      InitCommonControls ();

  		n_NBL::dllInstance = (HINSTANCE) hModule;

      n_NBL::g_Enable       = NULL;
      n_NBL::g_Channel      = NULL;
      n_NBL::g_Self         = NULL;
      n_NBL::g_Num_Controls = 0;
      n_NBL::g_Controls     = NULL;

  		for (i = 0; i < NR_MAX_LISTENERS; i++)
	  	{
		  	g_Listeners [i].f_Channel  = -1;
			  g_Listeners [i].f_Callback = NULL;
      }

      break;
    case DLL_THREAD_ATTACH:
  		break;
    case DLL_THREAD_DETACH:
      break;
    case DLL_PROCESS_DETACH:
      break;
    }

    return TRUE;
}

///////////////////////////////////////////////////////////////////////////////

c_Broadcast_Listener_CB::c_Broadcast_Listener_CB (void)
{
  int i;

	f_Queue_Size = 0;

	for (i = 0; i < NR_RX_QUEUE_MAX; i++)
	{
		f_Queue_Order [i] = i;
	}

	f_Tick = false;

  f_Transpose    = 0;
  f_Ignore_Notes = false;

  for (i = 0; i < 8; i++)
  {
    f_Controls [i].f_Override       = false;
    f_Controls [i].f_Mapped_Control = -1;
    f_Controls [i].f_Mapped_Start   = 0;
    f_Controls [i].f_Mapped_End     = 65534;
    f_Controls [i].f_Mapped_Diff    = 65534;
  }
}

///////////////////////////////////////////////////////////////////////////////

void c_Broadcast_Listener_CB::Queue_Command (int                 p_Channel,
                                             c_Broadcast_Params *p_Command )
{
	if (f_Queue_Size == NR_RX_QUEUE_MAX)
	{
		return;
	}

	int i = f_Queue_Size;
	int j = f_Queue_Order [i];

	f_Queue_Size++;

	f_Queue_Channel [j] =  p_Channel;
	f_Queue_Data    [j] = *p_Command;

	int k;

	i--;

	while (i >= 0)
	{
		k = f_Queue_Order [i];

		if (f_Queue_Data [k].p_Time > f_Queue_Data [j].p_Time)
		{
			f_Queue_Order [i    ] = j;
			f_Queue_Order [i + 1] = k;

			i--;
		}
		else
		{
			break;
		}
	}
}

///////////////////////////////////////////////////////////////////////////////

void c_Broadcast_Listener_CB::Handle_Tick (void)
{
  f_Tick = true;
}

///////////////////////////////////////////////////////////////////////////////

bool c_Broadcast_Listener_CB::Handle_Work (float     *psamples,
                    										   int        numsamples,
										                       int const  mode       )
{
	bool l_Return = false;

	int l_Start_Sample = f_Master_Info->PosInTick;

	//  Handle Tick2 and Work2 calls

  int    l_Curr_Sample = l_Start_Sample;
  float *l_Buffer_Pos  = psamples;

  int    l_Cmd_Sample;
  int    i, j;

  bool   l_Do_Work;

  while (l_Curr_Sample < (l_Start_Sample + numsamples))
  {
    l_Do_Work = true;

    if (f_Queue_Size >= 1)
    {
      i = f_Queue_Order [0];

      l_Cmd_Sample = (((int) f_Queue_Data [i].p_Time) * f_Master_Info->SamplesPerTick) >> 8;

      if (l_Cmd_Sample == l_Curr_Sample)
      {
        f_Master_Info->PosInTick = l_Curr_Sample;  //  Fool Tick2 handlers about current time

        switch (f_Queue_Data [i].p_Command)
        {
          case 0xC0 :  //  All Notes Off
          {
            f_All_Notes_Off = true;

            break;
          }
          case 0xC1 :  //  All Notes Ignore
          {
            f_Ignore_Notes = true;

            break;
          }
          case 0xC2 :  //  Cancel All Notes Ignore
          {
            f_Ignore_Notes = false;

            break;
          }
          case 0xC3 :  //  All Notes Transpose
          {
            int l_Semitones_Up   = 0;
            int l_Semitones_Down = 0;

            if (f_Queue_Data[i].p_Byte_Param1 != 0xFF)
            {
              l_Semitones_Up =   ((f_Queue_Data[i].p_Byte_Param1 >> 4) * 12)
                                 + (f_Queue_Data[i].p_Byte_Param1 & 0x0F);
            }

            if (f_Queue_Data[i].p_Byte_Param2 != 0xFF)
            {
              l_Semitones_Down =   ((f_Queue_Data[i].p_Byte_Param2 >> 4) * 12)
                                   + (f_Queue_Data[i].p_Byte_Param2 & 0x0F);
            }

            f_Transpose = l_Semitones_Up - l_Semitones_Down;

            break;
          }
          case 0xC4 :  //  Set controls - up to 4 at once
          {
            if (f_Queue_Data [i].p_Byte_Param1 < 8)
            {
              if (f_Queue_Data [i].p_Word_Param1 == 0xFFFF)
              {
                f_Controls [f_Queue_Data [i].p_Byte_Param1].Clear ();
              }
              else
              {
                f_Controls [f_Queue_Data [i].p_Byte_Param1].Set (f_Queue_Data [i].p_Word_Param1);
              }
            }

            if (f_Queue_Data [i].p_Byte_Param2 < 8)
            {
              if (f_Queue_Data [i].p_Word_Param2 == 0xFFFF)
              {
                f_Controls [f_Queue_Data [i].p_Byte_Param2].Clear ();
              }
              else
              {
                f_Controls [f_Queue_Data [i].p_Byte_Param2].Set (f_Queue_Data [i].p_Word_Param2);
              }
            }

            if (f_Queue_Data [i].p_Byte_Param3 < 8)
            {
              if (f_Queue_Data [i].p_Word_Param3 == 0xFFFF)
              {
                f_Controls [f_Queue_Data [i].p_Byte_Param3].Clear ();
              }
              else
              {
                f_Controls [f_Queue_Data [i].p_Byte_Param3].Set (f_Queue_Data [i].p_Word_Param3);
              }
            }

            if (f_Queue_Data [i].p_Byte_Param4 < 8)
            {
              if (f_Queue_Data [i].p_Word_Param4 == 0xFFFF)
              {
                f_Controls [f_Queue_Data [i].p_Byte_Param4].Clear ();
              }
              else
              {
                f_Controls [f_Queue_Data [i].p_Byte_Param4].Set (f_Queue_Data [i].p_Word_Param4);
              }
            }

            break;
          }
          case 0xC5 :  //  Set control slide up to 2 at once
          {
            if (   (f_Queue_Data [i].p_Byte_Param1 <  8     )  //  Control
                && (f_Queue_Data [i].p_Byte_Param2 != 0     )  //  Time
                && (f_Queue_Data [i].p_Byte_Param2 != 0xFF  )
                && (f_Queue_Data [i].p_Word_Param1 != 0xFFFF)  //  Start
                && (f_Queue_Data [i].p_Word_Param2 != 0xFFFF)) //  End
            {
              f_Controls [f_Queue_Data [i].p_Byte_Param1].Set
                                       (f_Queue_Data [i].p_Word_Param1,
                                        f_Queue_Data [i].p_Word_Param2,
                                        f_Queue_Data [i].p_Byte_Param2 );
            }

            if (   (f_Queue_Data [i].p_Byte_Param3 <  8     )  //  Control
                && (f_Queue_Data [i].p_Byte_Param4 != 0     )  //  Time
                && (f_Queue_Data [i].p_Byte_Param4 != 0xFF  )
                && (f_Queue_Data [i].p_Word_Param3 != 0xFFFF)  //  Start
                && (f_Queue_Data [i].p_Word_Param4 != 0xFFFF)) //  End
            {
              f_Controls [f_Queue_Data [i].p_Byte_Param3].Set
                                       (f_Queue_Data [i].p_Word_Param3,
                                        f_Queue_Data [i].p_Word_Param4,
                                        f_Queue_Data [i].p_Byte_Param4 );
            }

            break;
          }
          default :
          {
            Tick2 (f_Queue_Channel [i], &f_Queue_Data [i]);
          }
        }

        //  Delete handled item

        for (j = 0; j < f_Queue_Size - 1; j++)
        {
          f_Queue_Order [j] = f_Queue_Order [j + 1];
        }

        f_Queue_Size--;
        f_Queue_Order [f_Queue_Size] = i;

        l_Do_Work = false;  //  Put off work until further tick calls can be done
      }
      else if (l_Cmd_Sample > l_Start_Sample + numsamples)
      {
        l_Cmd_Sample = l_Start_Sample + numsamples;
      }
    }
    else
    {
      l_Cmd_Sample = l_Start_Sample + numsamples;
    }

    if (l_Do_Work)
    {
      if (f_Tick)
      {
        //  Handle parameter modifying commands - note partial-tick time offset ignored
        if (f_All_Notes_Off)
        {
          f_All_Notes_Off = false;

          All_Notes_Off ();
        }
        else if (f_Ignore_Notes)
        {
          All_Notes_Ignore ();
        }
        else
        {
          if (f_Transpose != 0)
          {
            Transpose_Notes (f_Transpose);
          }
        }

        for (int i = 0; i < 8; i++)
        {
          if (f_Controls [i].f_Override)
          {
            Set_Control (f_Controls [i].f_Mapped_Control, f_Controls [i].f_Curr_Value);

            if (f_Controls [i].f_Ticks_Remaining == 0)
            {
              f_Controls [i].Clear ();
            }
            else
            {
              f_Controls [i].Update ();
            }
          }
        }

        Tick2 ();

    	  f_Tick = false;
      }

      l_Cmd_Sample -= l_Curr_Sample;  //  How many samples to do

      if (Work2 (l_Buffer_Pos, l_Cmd_Sample, mode, l_Curr_Sample - l_Start_Sample))
  	  {
	  	  l_Return = true;
	    }

      l_Buffer_Pos  += l_Cmd_Sample;
      l_Curr_Sample += l_Cmd_Sample;
    }
  }


	f_Master_Info->PosInTick = l_Start_Sample;

	//  If last Work before Tick, purge queue

	if (l_Curr_Sample == f_Master_Info->SamplesPerTick)
	{
		int i, j, k;

		//
		//  Commands for this tick should be deleted by now,
		//  but better safe than sorry

		int l_Deleted [NR_RX_QUEUE_MAX];
		int l_Num_Deleted = 0;

		i = 0;

		for (j = 0; j < f_Queue_Size; j++)
		{
			k = f_Queue_Order [j];

			if (f_Queue_Data [k].p_Time < 0x0100)
			{
				l_Deleted [l_Num_Deleted] = k;
				l_Num_Deleted++;
			}
			else
			{
				f_Queue_Data [k].p_Time -= 0x0100;
				f_Queue_Order [i] = k;
				i++;
			}
		}

		for (j = 0; j < l_Num_Deleted; j++)
		{
			f_Queue_Order [i] = l_Deleted [j];
			i++;
		}

		f_Queue_Size -= l_Num_Deleted;
	}

	return l_Return;
}

///////////////////////////////////////////////////////////////////////////////

bool NR_Start_Listening (int p_Channel, c_Broadcast_Listener_CB *p_Callback)
{
	int i;

	for (i = 0; i < NR_MAX_LISTENERS; i++)
	{
		if (g_Listeners [i].f_Channel == -1)
		{
			g_Listeners [i].f_Channel  = p_Channel;
			g_Listeners [i].f_Callback = p_Callback;

			return true;
		}
	}

	return false;  //  No free slots
}

///////////////////////////////////////////////////////////////////////////////

void NR_Stop_Listening  (int p_Channel, c_Broadcast_Listener_CB *p_Callback)
{
	int i;

	for (i = 0; i < NR_MAX_LISTENERS; i++)
	{
		if (   (g_Listeners [i].f_Channel  == p_Channel )
			&& (g_Listeners [i].f_Callback == p_Callback))
		{
			g_Listeners [i].f_Channel  = -1;
			g_Listeners [i].f_Callback = NULL;
		}
	}
}

///////////////////////////////////////////////////////////////////////////////

void NR_Send_Command (int p_Channel, c_Broadcast_Params *p_Command )
{
  int i;

  for (i = 0; i < NR_MAX_LISTENERS; i++)
  {
    if (g_Listeners [i].f_Channel == p_Channel)
    {
      g_Listeners [i].f_Callback->Queue_Command (p_Channel, p_Command);
    }
  }
}

///////////////////////////////////////////////////////////////////////////////

//
//  This mapping is just to make the dialog easier to work with
//

struct c_Map
{
  int f_Combo;
  int f_Low_Edit;
  int f_High_Edit;
};

c_Map g_Map [8] =
{
  {IDC_COMBO1, IDC_EDIT1, IDC_EDIT9 },
  {IDC_COMBO2, IDC_EDIT2, IDC_EDIT10},
  {IDC_COMBO3, IDC_EDIT3, IDC_EDIT11},
  {IDC_COMBO4, IDC_EDIT4, IDC_EDIT12},
  {IDC_COMBO5, IDC_EDIT5, IDC_EDIT13},
  {IDC_COMBO6, IDC_EDIT6, IDC_EDIT14},
  {IDC_COMBO7, IDC_EDIT7, IDC_EDIT15},
  {IDC_COMBO8, IDC_EDIT8, IDC_EDIT16}
};

///////////////////////////////////////////////////////////////////////////////

BOOL APIENTRY ListenDialog (HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg)
	{
	case WM_INITDIALOG :

		CheckDlgButton (hDlg, IDC_ENABLE_CHECK, *n_NBL::g_Enable);

		{
			char  l_Buf [80];

			sprintf (l_Buf, "%d", *n_NBL::g_Channel);  SetDlgItemText (hDlg, IDC_CHANNEL_EDIT,  l_Buf);

			SendDlgItemMessage (hDlg, IDC_CHANNEL_SPIN, UDM_SETBUDDY, (WPARAM) (HWND) GetDlgItem (hDlg, IDC_CHANNEL_EDIT), 0L);
			SendDlgItemMessage (hDlg, IDC_CHANNEL_SPIN, UDM_SETRANGE, 0, MAKELONG(7, 0));

      int i, j;

      for (i = 0; i < 8; i++)
      {
        SendDlgItemMessage (hDlg, g_Map[i].f_Combo, CB_LIMITTEXT, 31, 0L);
      	SendDlgItemMessage (hDlg, g_Map[i].f_Combo, CB_RESETCONTENT, 0, 0L);

        SendDlgItemMessage (hDlg, g_Map[i].f_Combo, CB_ADDSTRING, 0, (LONG) "-");

        for (j = 0; j < n_NBL::g_Num_Controls; j++)
        {
          SendDlgItemMessage (hDlg, g_Map[i].f_Combo, CB_ADDSTRING, 0, (LONG) n_NBL::g_Controls [j].f_Name);
        }

        SendDlgItemMessage (hDlg, g_Map[i].f_Combo, CB_SETCURSEL, n_NBL::g_Self->f_Controls [i].f_Mapped_Control + 1, 0);

  			sprintf (l_Buf, "%d", n_NBL::g_Self->f_Controls [i].f_Mapped_Start);
        SetDlgItemText (hDlg, g_Map[i].f_Low_Edit,  l_Buf);

  			sprintf (l_Buf, "%d", n_NBL::g_Self->f_Controls [i].f_Mapped_End);
        SetDlgItemText (hDlg, g_Map[i].f_High_Edit,  l_Buf);
      }
		}

		return 1;
	case WM_COMMAND :
		switch (LOWORD (wParam))
		{
			case IDC_ENABLE_CHECK :
			{
				bool l_Enabled = (SendDlgItemMessage (hDlg, IDC_ENABLE_CHECK, BM_GETCHECK, 0, 0) == BST_CHECKED);

				if (*n_NBL::g_Enable)
				{
					if (!l_Enabled)
					{
						NR_Stop_Listening  (*n_NBL::g_Channel, n_NBL::g_Self);
					}
				}
				else
				{
					if (l_Enabled)
					{
						NR_Start_Listening (*n_NBL::g_Channel, n_NBL::g_Self);
					}
				}

				*n_NBL::g_Enable = l_Enabled;
				return 1;
			}
			case IDC_CHANNEL_EDIT :
			{
				char  l_Buf [80];

				GetDlgItemText (hDlg, IDC_CHANNEL_EDIT, l_Buf, 32);

				int l_Channel = atoi (l_Buf);

				if ((l_Channel >= 0) && (l_Channel <= 7) && (l_Channel != *n_NBL::g_Channel))
				{
					if (*n_NBL::g_Enable)
					{
						NR_Stop_Listening  (*n_NBL::g_Channel, n_NBL::g_Self);
						*n_NBL::g_Channel = l_Channel;
						NR_Start_Listening (l_Channel, n_NBL::g_Self);
					}
					else
					{
						*n_NBL::g_Channel = l_Channel;
					}
				}

				return 1;
			}
			case IDOK :
			{
        EndDialog (hDlg, TRUE);

				return 1;
			}
      default :
      {
        if ((LOWORD (wParam) >= IDC_EDIT1) && (LOWORD (wParam) <= IDC_EDIT8))  //  Low Value
        {
          int i = LOWORD (wParam) - IDC_EDIT1;  //  Control ID

  				char  l_Buf [80];

	  			GetDlgItemText (hDlg, g_Map[i].f_Low_Edit, l_Buf, 32);

		  		int l_Value = atoi (l_Buf);

          if ((l_Value >= 0) && (l_Value <= 65534))
          {
            n_NBL::g_Self->f_Controls [i].f_Mapped_Start = l_Value;

            n_NBL::g_Self->f_Controls [i].f_Mapped_Diff =
                   n_NBL::g_Self->f_Controls [i].f_Mapped_End
                 - n_NBL::g_Self->f_Controls [i].f_Mapped_Start;
          }
        }
        else if ((LOWORD (wParam) >= IDC_EDIT9) && (LOWORD (wParam) <= IDC_EDIT16))  //  High Value
        {
          int i = LOWORD (wParam) - IDC_EDIT9;  //  Control ID

  				char  l_Buf [80];

	  			GetDlgItemText (hDlg, g_Map[i].f_High_Edit, l_Buf, 32);

		  		int l_Value = atoi (l_Buf);

          if ((l_Value >= 0) && (l_Value <= 65534))
          {
            n_NBL::g_Self->f_Controls [i].f_Mapped_End = l_Value;

            n_NBL::g_Self->f_Controls [i].f_Mapped_Diff =
                   n_NBL::g_Self->f_Controls [i].f_Mapped_End
                 - n_NBL::g_Self->f_Controls [i].f_Mapped_Start;
          }
        }
        else if ((LOWORD (wParam) >= IDC_COMBO1) && (LOWORD (wParam) <= IDC_COMBO8))  //  Control
        {
          int i = LOWORD (wParam) - IDC_COMBO1;  //  Control ID

          int j = SendDlgItemMessage (hDlg, g_Map[i].f_Combo, CB_GETCURSEL, 0, 0) - 1;

          if ((j >= -1) && (j < n_NBL::g_Num_Controls))
          {
            n_NBL::g_Self->f_Controls [i].f_Mapped_Control = j;
          }
        }

        break;
      }
		}
	}

	return 0;
}


///////////////////////////////////////////////////////////////////////////////

void NR_Dialog_Enable_Channel (c_Broadcast_Listener_CB *p_Self,
                               bool                    *p_Enable,
                               int                     *p_Channel,
                               int                      p_Num_Controls,
                               c_Control_Config        *p_Controls     )
{
  n_NBL::g_Self         = p_Self;
  n_NBL::g_Enable       = p_Enable;
  n_NBL::g_Channel      = p_Channel;
  n_NBL::g_Num_Controls = p_Num_Controls;
  n_NBL::g_Controls     = p_Controls;

  DialogBox (n_NBL::dllInstance, MAKEINTRESOURCE (IDD_LISTEN_CHAN), 
             GetForegroundWindow (), (DLGPROC) &ListenDialog       );

  n_NBL::g_Self         = NULL;
  n_NBL::g_Enable       = NULL;
  n_NBL::g_Channel      = NULL;
  n_NBL::g_Num_Controls = 0;
  n_NBL::g_Controls     = NULL;
}

///////////////////////////////////////////////////////////////////////////////
